const express = require("express");
const router = express.Router();
const campusController = require("../controllers/campusController");
const {
  uploadCampusMedia,
} = require("../storage/middlewareStorage/uploadCampusMedia");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

// --- Public Routes (Protected by API Key) ---
router.route("/").get(checkApiKey, campusController.getAllCampuses);

router.route("/:id").get(checkApiKey, campusController.getCampus);

// --- Protected Routes (Logged-in Admins Only) ---
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

// Create Campus
router.route("/").post(uploadCampusMedia, campusController.createCampus);

// Update or Delete Campus
router
  .route("/:id")
  .patch(uploadCampusMedia, campusController.updateCampus)
  .delete(campusController.deleteCampus);

module.exports = router;
